<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('kpis_questions', function (Blueprint $table) {
            $table->id();
            $table->integer('kpi_id')->default(0);
            $table->text('question')->nullable();
            $table->integer('weight')->default(0);
            $table->integer('order')->default(0);
            $table->integer('updated_by')->default(0);
            $table->integer('created_by')->default(0);
            $table->integer('deleted_by')->default(0);
            $table->softDeletes();
            $table->timestamps();
            $table->index('id','id_index');
            $table->index('kpi_id','kpi_id_index');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('kpis_questions');
    }
};
