@extends('dashboard.layouts.app')
@push('headScripts')
@endpush
@section('content')

    <div class="container-xxl flex-grow-1 container-p-y">
        <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">{{ __('User Profile') }} / {{ (isset($user))?__('Edit :type',['type'=>$user->name]):__('Create') }}</h4>
        <div class="row">
            <div class="col-md-12">
                <div class="card mb-4">
                    <h5 class="card-header">{{ __('User Profile') }}</h5>
                    <form method="POST" action="{{ route('users.profile_update') }}" enctype="multipart/form-data">
                        @if(isset($user))
                            @method('PUT')
                        @endif
                        @csrf
                        <div class="card-body">
                            <div class="d-flex align-items-start align-items-sm-center gap-4">
                                <img src="@if(isset($user)&&$user->image_dir){{ asset($user->image_dir.$user->image) }}@else{{ asset('assets/img/avatars/1.png') }}@endif" alt="user-avatar" class="d-block rounded" height="100" width="100" id="uploadedAvatar">
                                <div class="button-wrapper">
                                    <label for="upload" class="btn btn-primary me-2 mb-4" tabindex="0">
                                        <span class="d-none d-sm-block">Upload new photo</span>
                                        <i class="bx bx-upload d-block d-sm-none"></i>
                                        <input type="file" id="upload" class="account-file-input" name="image" hidden="" accept="image/png, image/jpeg">
                                    </label>
                                    <button type="button" class="btn btn-outline-secondary account-image-reset mb-4">
                                        <i class="bx bx-reset d-block d-sm-none"></i>
                                        <span class="d-none d-sm-block">Reset</span>
                                    </button>

                                    <p class="text-muted mb-0">Allowed JPG, GIF or PNG. Max size of 800K</p>
                                </div>
                            </div>
                        </div>
                        <hr class="mb-0">
                        <div class="card-body">
                            <div class="row">
                                <div class="form-group col-lg-4 mb-3">
                                    <label class="form-label">{{ __('Parent') }} <span class="badge bg-info">{{ __('Responsible Employee') }}</span></label>
                                    @php($user=isset($user)?$user:null)
                                    <select class="select2" disabled data-placeholder="{{ __('Select :type',['type'=>__('Responsible Employee')]) }}" name="parent_id">
                                        <option value="">{{ __('Select :type',['type'=>__('Responsible Employee')]) }}</option>
                                        @foreach(\App\Models\User::where(function ($q)use($user){$q->where('parent_id',0)->where('id','!=',(isset($user)?$user->id:0));})->pluck('name','id')->toArray() as $id=>$name)
                                            <option @if((isset($user)&&$user->parent_id==$id)||old('parent_id')==$id) selected="selected" @endif value="{{ $id }}">{{ $name }}</option>
                                            {!! selectSup($id,(isset($user)?$user->parent_id:old('parent_id')),null,(isset($user)?$user->id:0)) !!}
                                        @endforeach
                                    </select>
                                    @error('parent_id')
                                    <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group col-lg-4 mb-3">
                                    <label class="form-label">{{ __('Departments') }}</label>
                                    <select class="select2" disabled data-placeholder="{{ __('Select :type',['type'=>__('Department')]) }}" name="department_id">
                                        <option value="">{{ __('Select :type',['type'=>__('Department')]) }}</option>
                                        @foreach(\App\Models\Department::pluck('title','id')->toArray() as $id=>$name)
                                            <option @if((isset($user)&&$user->department_id==$id)||old('department_id')==$id) selected="selected" @endif value="{{ $id }}">{{ $name }}</option>
                                        @endforeach
                                    </select>
                                    @error('department_id')
                                    <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group col-lg-4 mb-3">
                                    <label class="form-label">{{ __('Job Titles') }}</label>
                                    <select class="select2" disabled data-placeholder="{{ __('Select :type',['type'=>__('Job Title')]) }}" name="job_title_id">
                                        <option value="">{{ __('Select :type',['type'=>__('Job Title')]) }}</option>
                                        @foreach(\App\Models\JobTitle::pluck('title','id')->toArray() as $id=>$name)
                                            <option @if((isset($user)&&$user->job_title_id==$id)||old('job_title_id')==$id) selected="selected" @endif value="{{ $id }}">{{ $name }}</option>
                                        @endforeach
                                    </select>
                                    @error('job_title_id')
                                    <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group col-lg-6 mb-3">
                                    <label class="form-label">{{ __('Name') }}</label>
                                    <input type="text" class="form-control @error('name') is-invalid @enderror border-left-0" name="name" id="name" value="{{ isset($user)?$user->name:old('name') }}" placeholder="{{ __('Enter :value',['value'=>__('User Name')]) }}">
                                    @error('name')
                                    <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                    @enderror

                                </div>
                                <div class="form-group col-lg-6 mb-3">
                                    <label class="form-label">{{ __('Email Address') }}</label>
                                    <input type="email" class="form-control @error('email') is-invalid @enderror border-left-0" name="email" id="email" value="{{ isset($user)?$user->email:old('email') }}" placeholder="{{ __('Enter :value',['value'=>__('Email Address')]) }}">
                                    @error('email')
                                    <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group col-lg-6 mb-3">
                                    <label class="form-label">{{ __('Mobile') }}</label>
                                    <input type="tel" class="form-control @error('mobile') is-invalid @enderror border-left-0" name="mobile" id="mobile" value="{{ isset($user)?$user->mobile:old('mobile') }}" placeholder="{{ __('Enter :value',['value'=>__('Mobile')]) }}">
                                    @error('mobile')
                                    <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group col-lg-6 mb-3">
                                    <label class="form-label">{{ __('Birth Date') }}</label>
                                    <input type="date" class="form-control @error('birth_date') is-invalid @enderror border-left-0" name="birth_date" id="birth_date" value="{{ isset($user)?$user->birth_date:old('birth_date') }}" placeholder="{{ __('Enter :value',['value'=>__('Birth Date')]) }}">
                                    @error('birth_date')
                                    <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group col-lg-12">
                                    <label class="form-label">{{ __('Old Password') }}</label>
                                    <input type="password" class="form-control @error('old_password') is-invalid @enderror border-left-0" name="old_password" id="old_password" placeholder="{{ __('Enter :value',['value'=>__('Old Password')]) }}">
                                    @error('old_password')
                                    <span class="invalid-feedback" user="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="form-group col-lg-12">
                                    <label class="form-label">{{ __('New Password') }}</label>
                                    <input type="password" class="form-control @error('new_password') is-invalid @enderror border-left-0" name="new_password" id="new_password" placeholder="{{ __('Enter :value',['value'=>__('New Password')]) }}">
                                    @error('new_password')
                                    <span class="invalid-feedback" user="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="form-group col-lg-12">
                                    <label class="form-label">{{ __('Confirm Password') }}</label>
                                    <input type="password" class="form-control @error('confirm_password') is-invalid @enderror border-left-0" name="confirm_password" id="confirm_password" placeholder="{{ __('Enter :value',['value'=>__('Confirm Password')]) }}">
                                    @error('confirm_password')
                                    <span class="invalid-feedback" user="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="text-center">
                            <button type="submit" class="btn btn-danger px-5">{{ __('Save') }}</button>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
@endsection

@push('footerScripts')

@endpush
