<?php

namespace Database\Factories;

use App\Models\JobTitle;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\KPIS>
 */
class KPIFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        $jobTitle=JobTitle::whereRaw("id NOT IN(SELECT job_title_id FROM kpis)")->inRandomOrder()->first();
        return [
            //
            'job_title_id'=>$jobTitle?$jobTitle->id:0,
            'name'=>fake()->text(),
            'status'=>fake()->randomElement(config('app.statusArray')),
        ];
    }
}
